<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    public function run()
    {
        $permissions = [
            'المستخدمين',
            'الجلسات',
            'قضايا المكتب',
            'المحامين',
            'اللوجو',
            'اقسام القضايا',
            'المقالات',
            'بيانات التواصل',
            'الاضافات',
            'الاجندة السنوية',
            'أوامر العمل',
            'اوامر العمل',
            'متعلقات القضايا',
            'التقارير',
            'اضافة قضية',
            'تفاصيل القضية',
            'تعديل القضية',
            'نقل القضية للأرشيف',
            'حذف القضية',
            'اضافة جلسة',
            'تفاصيل الجلسة',
            'تعديل الجلسة',
            'نقل الجلسة للأرشيف',
            'حذف الجلسة',
            'اضافة محامى',
            'تعديل بيانات المحامى',
            'حذف المحامى',
            'اضافة موكل',
            'قضايا الموكل',
            'تغيير كلمة المرور للموكل',
            'تعديل بيانات الموكل',
            'نقل الموكل للأرشيف',
            'حذف الموكل',
            'اخر الجلسات',
            'الارشيف',
'اضافة اوامر العمل',
'حسابات المؤسسة',

        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'admin', // تأكد من أن الحارس هو admin
            ]);
        }
    }
}
