<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Admin;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateAdminUserSeeder extends Seeder
{
    public function run()
    {
        // التحقق إذا كان الـ Admin موجودًا مسبقًا
        $admin = Admin::firstOrCreate(
            ['email' => 'admin@gmail.com'], // شرط البحث
            [
                'password' => bcrypt('password'),
                'status' => 'مفعل',
                'getRoleNames' => 'admin',
            ]
        );

        // التحقق إذا كان الدور موجودًا مسبقًا مع الحارس المناسب
        $role = Role::firstOrCreate(
            ['name' => 'Admin', 'guard_name' => 'admin']  // تأكد من تطابق الحارس
        );

        // إسناد الدور للـ Admin إذا لم يكن قد تم إسناده مسبقًا
        if (!$admin->hasRole($role)) {
            $admin->assignRole($role);
        }

        // إضافة الأذونات
        $permissions = ['المستخدمين'];
        foreach ($permissions as $permission) {
            $perm = Permission::firstOrCreate(
                ['name' => $permission, 'guard_name' => 'admin']
            );

            // إسناد الأذونات إلى الدور
            $role->givePermissionTo($perm);
        }
    }
}
