<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            Schema::create('messages', function (Blueprint $table) {
                $table->id(); // مفتاح أساسي تلقائي
                $table->enum('sender_type', ['User', 'Lawyer']); // نوع المرسل
                $table->text('message'); // نص الرسالة
                $table->timestamps(); // يحتوي على created_at و updated_at
            });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('messages');
    }
}
