<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvestInnersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invest_inners', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invest_id');
            $table->foreign('invest_id')->references('id')->on('invests')->onDelete('cascade');
            $table->string('title_ar');
            $table->string('title_en');
            $table->string('slug')->unique();
            $table->string('photo');
            $table->LONGTEXT('details_ar');
            $table->LONGTEXT('details_en');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invest_inners');
    }
}
