<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Auth;
use App\Models\session;

class SessionAdded extends Notification
{
    use Queueable;
    private $sessions;

    /**
     * Create a new notification instance.
     *
     * @return void
     */


    public function __construct(session $sessions)
    {
        $this->sessions = $sessions;
    }

    public function via($notifiable)
    {
        return ['database']; // تخزين الإشعار في قاعدة البيانات
    }

    public function toDatabase($notifiable)
    {
        return [
            'id' => $this->sessions->id,
            'title'=>'تم اضافة فاتورة جديد بواسطة :',
            'user'=> Auth::user()->name,
        ];
    }

}
