<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class session extends Model
{
    use SoftDeletes;
    protected $table = "sessions";
    protected $fillable = ['client_id', 'file_id', 'lawyer_id', 'court_id', 'date', 'photo', 'postponementDate', 'requests', 'notes', 'details', 'created_at', 'updated_at'];
    protected $hidden = ['created_at, updated_at'];


    public function lawyers()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\lawyer', 'lawyer_id');
    }

    public function courts()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\court', 'court_id');
    }

    public function clients()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\client', 'client_id');
    }



    public function files()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\file', 'file_id');
    }



}
