<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class job extends Model
{
    protected $table = "jobs";
    protected $fillable = ['client_id', 'file_id', 'lawyer_id', 'court_id', 'date',  'details', 'police_id', 'created_at', 'updated_at'];
    protected $hidden = ['created_at, updated_at'];


    public function lawyers()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\lawyer', 'lawyer_id');
    }

    public function courts()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\court', 'court_id');
    }

    public function clients()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\client', 'client_id');
    }

    public function files()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\file', 'file_id');
    }

    public function polices()  /*** table name ***/
    {
        return $this->belongsTo('App\Models\police', 'police_id');
    }

}
