<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class document extends Model
{
    protected $table = "documents";
    protected $fillable = ['client_id', 'type', 'file_id', 'photo', 'details', 'created_at', 'updated_at'];
    protected $hidden = ['created_at, updated_at'];


    public function clients()
    {
        return $this->belongsTo('App\Models\Client', 'client_id');
    }


    public function companies()
    {
        return $this->belongsTo('App\Models\Company', 'company_id');
    }


    public function files()
    {
        return $this->belongsTo('App\Models\file', 'file_id');
    }
}
