<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class blog extends Model
{
    use SoftDeletes;
    protected $table = "blogs";
    protected $fillable = ['title_ar', 'title_en', 'date', 'details_ar', 'details_en', 'photo', 'created_at', 'updated_at'];
    protected $dates = ['deleted_at'];
    protected $hidden = ['created_at, updated_at'];


    public function comments()
    {
        return $this->hasMany(comment::class, 'blog_id');
    }

}
