<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class casesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title_ar' => 'unique:cases_s'.$this->id,
            'title_en' => 'unique:cases_s'.$this->id,
        ];
    }

    public function messages()
    {
        return [
            'title_ar.required' => 'العنوان مطلوب',
            'title_ar.unique' => 'العنوان بالعربى مكرر',
            'title_en.required' => 'العنوان مطلوب',
            'title_en.unique' => 'العنوان بالانجليزى مكرر',
        ];
    }
}
