<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    public function handle($request, Closure $next)
    {
        // تحقق إذا كان المستخدم مسجلاً كـ "أدمن"
        if (Auth::check() && Auth::user()->hasRole('admin')) {
            return $next($request);
        }

        // إعادة توجيه إذا لم يكن المستخدم أدمن
        return redirect('/'); // الموقع الخارجي
    }
}
