<?php


namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use LaravelLocalization;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\clientLoginRequest;
use App\Http\Requests\attachRequest;
use App\Http\Requests\clientRequest;
use App\Models\attach;
use App\Models\client;
use App\Models\file;
use App\Models\logo;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use App\Models\document;
use App\Models\invest;
use App\Models\service;


use Auth;
use App\Traits\allTraits;

class userLoginController extends Controller
{

    use allTraits;

    function userLogin(){

        $logos =  logo::All();

        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

        $services =  service::select('id',
        'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
$allServices = $services;

        return view('front.userLogin', compact('logos', 'services', 'invests', 'allServices',  'phones', 'emails', 'addresses'));
    }




    public function userloginPost(clientLoginRequest $request)
    {
        $remember_me = $request->has('remember_me') ? true : false;

        if (auth()->guard('client')->attempt(['code' => $request->input("code"), 'password' => $request->input("password")], $remember_me)) {
            // notify()->success('تم الدخول بنجاح  ');
            return redirect()->route('userProfile', ['client_id' => auth()->guard('client')->user()->id]);
        }
        // notify()->error('خطا في البيانات  برجاء المجاولة مجدا ');
        return redirect()->back()->with(['error' => '']);
    }






    public function UpdateClientsSelf(clientRequest $request, $clients_id)
    {

        $client = client::find($clients_id);
        if (!$client)
            return redirect()->back();

        //update data


        $client->update([
            'password' => Hash::make($request->password),
            'address' => $request -> address,
            'phone' => $request -> phone,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }






    public function userProfile($clients_id)
    {
        $client = Client::with('files.sessions')->find($clients_id);

        $client = Client::with('files.documents')->find($clients_id);

        if (!$client) {
            return redirect()->back()->with('error', 'الموكل غير موجود');
        }

        $clients = client::all()->find($clients_id);
        $logos =  logo::All();

        $phones =  phone::All();
        $emails =  email::All();

        $services =  service::select('id',
        'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
        $allServices = $services;


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();

        return view('front.userProfile', compact('client', 'invests', 'services', 'allServices', 'clients', 'logos',  'phones', 'emails', 'addresses'));
    }



    public function UserLogout()
    {
        if(Auth::guard('client')->check()) // this means that the admin was logged in.
        {
            Auth::guard('client')->logout();
            return redirect()->route('index');
        }

    }




    public function attachPost(attachRequest $request)
    {

        $photo = array();
        if($files = $request->file('photo')){
            foreach($files as $file){
                $photo_name = md5(rand(1000, 10000));
                $ext = strtolower($file->getClientOriginalExtension()); // تعديل هنا
                $photo_full_name = $photo_name.'.'.$ext;
                $upload_path = 'images/attach/';
                $photo_url = $upload_path.$photo_full_name;
                $file->move($upload_path, $photo_full_name);
                $photo[] = $photo_url;
            }
        }
        attach::create([
            'file_id' => $request -> file_id,
            'photo' => implode('|', $photo),
        ]);

        return redirect()->back()->with(['successSendMessages' => '']);
    }



}
