<?php



namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\logo;
use App\Models\service;
use App\Models\blog;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use App\Models\white_logo;
use App\Http\Requests\sendMessagesRequest;



class sendMessagesController extends Controller
{


    public function sendMessagesStore(sendMessagesRequest $request)
    {


        addSendMessages::create([
            'name' => $request -> name,
            'phone' => $request -> phone,
            'email' => $request -> email,
            'subject' => $request -> subject,
            'message' => $request -> message,

        ]);

        return redirect()->back()->with(['successSendMessages' => '']);

    }



    function sendMessages(){
        $logos =  logo::All();
        $white_logos =  white_logo::All();


        $blogs =  blog::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'photo',
        'date',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details') -> get();
        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::All();




        return view('front.realStateUnitType' , compact('logos','blogs', 'phones', 'emails', 'addresses', 'white_logos' ));

    }

}
