<?php


namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\logo;
use App\Models\project;
use App\Models\phone;
use App\Models\email;
use App\Models\Address;
use App\Models\white_logo;

use LaravelLocalization;

class projectsController extends Controller
{

    function projects(){

        $logos =  logo::All();
        $projects =  project::select('id',
        'name',
        'mainPhoto',
        'duration',
        'photo',
        'url',
        'service_id',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details') -> get();
        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::All();
        $white_logos =  white_logo::All();

        return view('front.projects', compact('logos', 'projects', 'white_logos', 'phones', 'emails', 'addresses',));
    }


    public function projectDetails($projects_id)
    {


        $projects = project::find($projects_id);
        if (!$projects)
            return redirect()->back();

        $projects = project::select('id',
        'name',
        'mainPhoto',
        'duration',
        'photo',
        'url',
        'service_id',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details')->find($projects_id);
        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::All();
        $white_logos =  white_logo::All();
        $logos =  logo::All();
        return view('front.projectsDetails', compact('projects', 'logos', 'phones', 'emails', 'addresses', 'white_logos'));


    }



}
