<?php


namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use App\Models\logo;
use App\Models\lawyer;
use App\Models\blog;
use App\Models\caseModel;
use App\Models\phone;
use App\Models\email;
use App\Models\post;
use App\Models\Address;
use App\Models\service;
use App\Models\invest;


use App\Models\specialization;
use Auth;


use LaravelLocalization;

class homeController extends Controller
{

    function index(){

        $logos =  logo::All();
        $lawyers =  lawyer::select('id',
        'name_' . LaravelLocalization::getCurrentLocale() . ' as name',
        'photo',
        'specialization_id') -> get();
        $cases_s =  caseModel::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'photo',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details') -> get();

        // $blogs =  blog::select('id',
        // 'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        // 'photo',
        // 'date',
        // 'details_' . LaravelLocalization::getCurrentLocale() . ' as details') -> get();


        $invests =  invest::select('id',
         'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title') -> get();

        $posts = post::where('parent_id', null)->latest()->take(6)->get();

        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title', ) -> get();

        $services =  service::select('id',
        'slug',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',) -> get();
        $allServices = $services;

        // dd(Auth::check());
        $messages = [
            ['sender_type' => 'User', 'message' => 'Hello!'],
            ['sender_type' => 'Lawyer', 'message' => 'Hi, how can I help you?']
        ];
        return view('front.home', compact('logos', 'invests', 'messages', 'services', 'allServices', 'lawyers', 'cases_s', 'posts',  'phones', 'emails', 'addresses' ));
    }



    public function subscribeStore(subscribeRequest $request)
    {
        subscribe::create([

            'email' => $request -> email,

        ]);

        return redirect()->back()->with(['successSubscribeMessages' => '']);

    }





}
