<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\filesRequest;
use App\Http\Requests\docRequest;
use App\Models\client;
use App\Models\file;
use App\Models\session;
use App\Models\court;
use App\Models\attribute;
use App\Models\documentation_office;
use App\Models\attach;
use App\Models\police;
use App\Models\document;
use App\Models\bailiff;
use App\Models\expert;
use App\Models\dispute;
use App\Models\family_dispute;
use LaravelLocalization;
use App\Traits\allTraits;


class reportController extends Controller
{





    public function AllContractReport() {
        $files =  file::All();
        $clients =  client::All();
        $attributes =  attribute::All();
        $courts =  court::All();
        $documentation_offices =  documentation_office::All();
        $polices =  police::All();
        return view('admin.reports.contract', compact('clients', 'files', 'attributes', 'courts', 'documentation_offices', 'polices'));
    }



    public function searchContracts(Request $request)
{
    $attorneyTypes = $request->input('attorneyTypes');

    // تصفية الملفات بناءً على الأنواع المحددة
    $files = File::with(['client', 'court', 'police'])
                ->whereIn('attorneyType', $attorneyTypes)
                ->get();

    return view('admin.reports.contract', compact('files'));
}




}
