<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\serviceRequest;
use App\Models\news;
use Illuminate\Support\Str;
use LaravelLocalization;
use App\Traits\allTraits;


class newsController extends Controller
{
    use allTraits;

    public function addNews() {

        $new_s =  news::All();
        return view('admin.addNews', compact('new_s'));
    }


    public function newsPost(serviceRequest $request)
    {


        $file_name = $this->saveImage($request->photo, 'images/news');

        news::create([
            'photo' => $file_name,
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'date' => $request -> date,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
            'slug' => preg_replace('/[^\p{Arabic}a-zA-Z0-9\-]+/u', '-', $request->title_ar),

        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }


    public function allNews() {

        $new_s =  news::All();
        return view('admin.allNews', compact('new_s'));
    }


    public function deleteNews($new_s_id)
    {

        $new_s = news::find($new_s_id);

        if (!$new_s)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $new_s->delete();

        return redirect()
            ->route('news')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }


    public function editNews($new_s_id)
    {

        // addNews::findOrFail($news_id);
        $new_s = news::find($new_s_id);  // search in given table id only
        if (!$new_s)
            return redirect()->back();

        $new_s = service::all()->find($new_s_id);
        return view('admin.editServices', compact('new_s'));


    }


       public function UpdateNews(serviceRequest $request, $new_s_id)
{
    // check if service exists
    $news = news::find($new_s_id);
    if (!$news) {
        return redirect()->back()->with(['error' => 'الخدمة غير موجودة']);
    }

    // جهز البيانات للتحديث
    $data = [
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'date' => $request -> date,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
    ];

    // لو في صورة جديدة
    if ($request->hasFile('photo')) {
        $file_name = $this->saveImage($request->photo, 'images/news');
        $data['photo'] = $file_name;
    }

    // update مرة واحدة
    $news->update($data);

    return redirect()->back()->with(['successEdit' => 'تم التحديث بنجاح']);
}






}
