<?php

namespace App\Http\Controllers\admin;
use Illuminate\Support\Facades\Notification;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\jobsRequest;
use App\Models\client;
use App\Models\file;
use App\Models\lawyer;
use App\Models\court;
use App\Models\job;
use App\Models\police;
use Illuminate\Support\Facades\DB;
use App\Traits\allTraits;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class jobsController extends Controller
{

    public function jobPost(jobsRequest $request)
    {

        job::create([
            'client_id' => $request->client_id,
            'file_id' => $request->file_id,
            'lawyer_id' => $request->lawyer_id,
            'court_id' => $request->court_id,
            'police_id' => $request -> police_id,
            'date' => $request->date,
            'details' => $request->details,
        ]);


        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllJobs() {
        $user = auth()->user();

        // تحميل الجلسات مع العلاقات المطلوبة
        if ($user->hasRole('Admin')) {
            $jobs = job::with(['lawyers', 'clients', 'files', 'courts']) // تحميل العلاقات
                       ->orderBy('created_at', 'desc')
                       ->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات مع العلاقات المطلوبة
            $jobs = job::with(['lawyers', 'clients', 'files', 'courts'])
                       ->whereIn('file_id', $allowedCaseIds)
                       ->orderBy('created_at', 'desc')
                       ->get();
        }

        $files =  file::All();
        $clients =  client::All();
        $lawyers =  lawyer::All();
        $courts =  court::All();
        $polices =  police::All();

        return view('admin.dashboard.Jobs', compact('jobs', 'files', 'clients', 'lawyers', 'courts', 'polices'));
    }



    public function deleteJob($jobs_id)
    {

        $jobs = job::find($jobs_id);

        if (!$jobs)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $jobs->delete();

        return redirect()
            ->route('AllJobs')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }





    public function editJob($jobs_id)
    {

        $jobs = job::find($jobs_id);  // search in given table id only
        if (!$jobs)
            return redirect()->back();
        $jobs = job::all()->find($jobs_id);
        $files =  file::All();
        $clients =  client::All();
        $lawyers =  lawyer::All();
        $courts =  court::All();
        $polices =  police::All();
        return view('admin.dashboard.editJob', compact('jobs', 'files', 'clients', 'lawyers', 'courts', 'polices'));

    }



    public function UpdateJob(jobsRequest $request, $jobs_id)
    {

        $job = job::find($jobs_id);
        if (!$job)
            return redirect()->back();




        $job->update([
            'client_id' => $request->client_id,
            'file_id' => $request->file_id,
            'lawyer_id' => $request->lawyer_id,
            'court_id' => $request->court_id,
            'police_id' => $request -> police_id,
            'date' => $request->date,
            'details' => $request->details,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }




}
