<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\invest_innerRequest;
use App\Models\invest_inner;
use App\Models\invest;
use Illuminate\Support\Str;
use LaravelLocalization;
use App\Traits\allTraits;


class investInnerController extends Controller
{
    use allTraits;

    public function addInvestInners() {

        $invest_inners =  invest_inner::All();
         $invests =  invest::All();
        return view('admin.addInvestInners', compact('invest_inners', 'invests'));
    }


    public function investInnersPost(invest_innerRequest $request)
    {


        $file_name = $this->saveImage($request->photo, 'images/invest_inners');

        invest_inner::create([
            'photo' => $file_name,
            'invest_id' => $request->invest_id,
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
            'slug' => preg_replace('/[^\p{Arabic}a-zA-Z0-9\-]+/u', '-', $request->title_ar),

        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }


    public function allInvestInners() {

        $invest_inners =  invest_inner::All();
         $invests =  invest::All();
        return view('admin.allInvestInners', compact('invest_inners', 'invests'));
    }


    public function deleteInvestInners($invest_inners_id)
    {

        $invest_inners = invest_inner::find($invest_inners_id);

        if (!$invest_inners)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $invest_inners->delete();

        return redirect()
            ->route('allInvestInners')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }

public function editInvestInners($invest_inners_id)
{
    $invest_inners = invest_inner::find($invest_inners_id);

    if (!$invest_inners)
        return redirect()->back();

    $invests = invest::all();

    return view('admin.editInvestInners', compact('invest_inners', 'invests'));
}



       public function UpdateInvestInner(invest_innerRequest $request, $invest_inners_id)
{
    // check if invest_inner exists
    $invest_inner = invest_inner::find($invest_inners_id);
    if (!$invest_inner) {
        return redirect()->back()->with(['error' => 'الخدمة غير موجودة']);
    }

    // جهز البيانات للتحديث
    $data = [
            'invest_id' => $request->invest_id,
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
    ];

    // لو في صورة جديدة
    if ($request->hasFile('photo')) {
        $file_name = $this->saveImage($request->photo, 'images/invest_inners');
        $data['photo'] = $file_name;
    }

    // update مرة واحدة
    $invest_inner->update($data);

    return redirect()->back()->with(['successEdit' => 'تم التحديث بنجاح']);
}






}
