<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\filesRequest;
use App\Http\Requests\docRequest;
use App\Models\client;
use App\Models\file;
use App\Models\attach;
use App\Models\police;
use App\Models\document;
use App\Models\bailiff;
use App\Models\expert;
use App\Models\dispute;
use App\Models\family_dispute;
use App\Models\company;

use LaravelLocalization;
use App\Traits\allTraits;
use Illuminate\Support\Facades\DB;


class fileAttachController extends Controller
{


/******************************* doc ***************************/


    public function docPost(docRequest $request)
    {

        $photo = array();
        if($files = $request->file('photo')){
           foreach($files as $file){
                $originalName = $file->getClientOriginalName(); // ← اسم الملف الأصلي
                $photo_name = md5(rand(1000, 10000));
                $ext = strtolower($file->getClientOriginalExtension());
                $photo_full_name = $photo_name.'.'.$ext;
                $upload_path = 'images/document/';
                $photo_url = $upload_path.$photo_full_name;
                $file->move($upload_path, $photo_full_name);

                // احفظ المسار مع الاسم الأصلي لو أردت
            $photo[] = json_encode([
                    'path' => $photo_url,
                    'original' => $file->getClientOriginalName(),
                ]);
            }
        }

        if ($request->type === 'case') {
            $fileId = $request->case_file_id;
        } else {
            $fileId = $request->normal_file_id;
        }

        document::create([
            'client_id' => $request -> client_id,
            'type' => $request -> type,
            'file_id'   => $fileId,
            'photo' => implode('|', $photo),
            'details' => $request -> details,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllDocs() {
        $user = auth()->user();

        // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
        if ($user->hasRole('Admin')) {
            $documents = document::orderBy('created_at', 'desc')->get();
        } else {
            // جلب القضايا المسموح للمستخدم برؤيتها
            $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
                return str_replace('ارقام القضايا', '', $permission);
            })->toArray();

            // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
            $documents = document::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
        }

        $clients =  client::All();
        $companies =  company::All();
        $files =  file::All();
        return view('admin.dashboard.documents', compact('documents', 'companies', 'clients', 'files'));
    }


    public function deleteDocs($documents_id)
    {

        $documents = document::find($documents_id);

        if (!$documents)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $documents->delete();


            return redirect()->back()->with(['successDelete' => '']);
    }



    public function editDocument($documents_id)
    {

        $documents = document::find($documents_id);  // search in given table id only
        if (!$documents)
            return redirect()->back();
        $documents = document::all()->find($documents_id);
        $clients =  client::All();
         $companies =  company::All();
        $files =  file::All();
        return view('admin.dashboard.editDocument', compact('documents', 'companies', 'clients', 'files'));

    }

public function updateDocument(docRequest $request, $document_id)
{
    $document = Document::find($document_id);
    if (!$document)
        return redirect()->back();

    // استرجاع الصور القديمة
    $existingPhotos = [];
    if (!empty($document->photo)) {
        $existingPhotos = explode('|', $document->photo);
    }

    // تجهيز الصور الجديدة
    $photo = [];
    if ($files = $request->file('photo')) {
        foreach ($files as $uploadedFile) {
            $photo_name = md5(rand(1000, 10000));
            $ext = strtolower($uploadedFile->getClientOriginalExtension());
            $photo_full_name = $photo_name . '.' . $ext;
            $upload_path = 'images/document/';
            $photo_url = $upload_path . $photo_full_name;
            $uploadedFile->move(public_path($upload_path), $photo_full_name);
            $photo[] = $photo_url;
        }
    }

    // دمج الصور القديمة مع الجديدة
    $allPhotos = array_merge($existingPhotos, $photo);

    // تحديث البيانات
    $document->update([

        'type' => $request->type,
        'client_id' => $request->client_id,
        'file_id' => $request->file_id,
        'photo' => implode('|', $allPhotos),
        'details' => $request->details,
    ]);

    return redirect()->back()->with(['successEdit' => 'تم التحديث بنجاح']);
}

public function documentsDeleteFile(Request $request)
{
    $request->validate([
        'document_id' => 'required|integer',
        'file_path' => 'required|string',
    ]);

    $document = DB::table('documents')->where('id', $request->document_id)->first();

    if (!$document) {
        return response()->json(['message' => 'المستند غير موجود'], 404);
    }

    $files = explode('|', $document->photo);

    $updatedFiles = array_filter($files, function ($file) use ($request) {
        return trim($file) !== trim($request->file_path);
    });

    // حذف الملف من السيرفر
    $fullPath = public_path($request->file_path);
    if (file_exists($fullPath)) {
        if (!unlink($fullPath)) {
            return response()->json(['message' => 'فشل حذف الملف من السيرفر'], 500);
        }
    }

    // تحديث الحقل في قاعدة البيانات
    DB::table('documents')->where('id', $request->document_id)->update([
        'photo' => implode('|', $updatedFiles)
    ]);

    return response()->json(['message' => 'تم حذف الملف بنجاح']);
}






public function deleteSingleFile(Request $request)
{
    $document = DB::table('documents')->where('id', $request->document_id)->first();

    if (!$document || !$document->photo) {
        return back()->with('error', 'الملف غير موجود');
    }

    $files = explode('|', $document->photo);

    if (!isset($files[$request->file_index])) {
        return back()->with('error', 'الملف غير موجود في الفهرس المطلوب');
    }

    // حذف الملف فعلياً من السيرفر إذا أردت:
    $fileToDelete = $files[$request->file_index];
    if (!is_array(json_decode($fileToDelete, true))) {
        // فقط إذا كان مسار مباشر وليس JSON
        $fullPath = public_path($fileToDelete);
        if (file_exists($fullPath)) {
            unlink($fullPath);
        }
    }

    unset($files[$request->file_index]);

    $newPhotoValue = implode('|', $files);
    DB::table('documents')->where('id', $request->document_id)->update(['photo' => $newPhotoValue]);

    return redirect()->back()->with(['successDelete' => '']);
}







/*******************************end doc ***************************/






/******************************* start bailiffs ***************************/


public function bailiffPost(docRequest $request)
{


    bailiff::create([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'BailiffsPen' => $request -> BailiffsPen,
        'type' => $request -> type,
        'number' => $request -> number,
        'date' => $request -> date,
        'deliverer' => $request -> deliverer,
        'ReceivingOfficer' => $request -> ReceivingOfficer,
        'WorkResult' => $request -> WorkResult,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successAdd' => '']);
}


public function AllBailiffs() {

    $user = auth()->user();

    // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
    if ($user->hasRole('Admin')) {
        $bailiffs = bailiff::orderBy('created_at', 'desc')->get();
    } else {
        // جلب القضايا المسموح للمستخدم برؤيتها
        $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
            return str_replace('ارقام القضايا', '', $permission);
        })->toArray();

        // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
        $bailiffs = bailiff::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
    }
    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.bailiffs', compact('bailiffs', 'clients', 'files'));
}


public function deleteBailiff($bailiffs_id)
{

    $bailiffs = bailiff::find($bailiffs_id);

    if (!$bailiffs)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $bailiffs->delete();

               return redirect()->back()->with(['successDelete' => '']);
}





public function editBailiff($bailiffs_id)
{

    $bailiffs = bailiff::find($bailiffs_id);  // search in given table id only
    if (!$bailiffs)
        return redirect()->back();
    $bailiffs = bailiff::all()->find($bailiffs_id);
    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.editBailiff', compact('bailiffs', 'clients', 'files'));

}



public function UpdateBailiff(docRequest $request, $bailiffs_id)
{

    $bailiff = bailiff::find($bailiffs_id);
    if (!$bailiff)
        return redirect()->back();

    //update data



    $bailiff->update([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'BailiffsPen' => $request -> BailiffsPen,
        'type' => $request -> type,
        'number' => $request -> number,
        'date' => $request -> date,
        'deliverer' => $request -> deliverer,
        'ReceivingOfficer' => $request -> ReceivingOfficer,
        'WorkResult' => $request -> WorkResult,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

}



/*********************************************************** expert ***********************************************************/






public function expertsPost(docRequest $request)
{


    expert::create([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'date' => $request -> date,
        'time' => $request -> time,
        'missionAuthority' => $request -> missionAuthority,
        'expertName' => $request -> expertName,
        'value' => $request -> value,
        'type' => $request -> type,
        'subject' => $request -> subject,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successAdd' => '']);
}


public function AllExperts() {

    $user = auth()->user();

    // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
    if ($user->hasRole('Admin')) {
        $experts = expert::orderBy('created_at', 'desc')->get();
    } else {
        // جلب القضايا المسموح للمستخدم برؤيتها
        $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
            return str_replace('ارقام القضايا', '', $permission);
        })->toArray();

        // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
        $experts = expert::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
    }

    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.experts', compact('experts', 'clients', 'files'));
}


public function deleteExpert($experts_id)
{

    $experts = expert::find($experts_id);

    if (!$experts)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $experts->delete();

    return redirect()->back()->with(['successDelete' => '']);
}





public function editExperts($experts_id)
{

    $experts = expert::find($experts_id);  // search in given table id only
    if (!$experts)
        return redirect()->back();
    $experts = expert::all()->find($experts_id);
    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.editExperts', compact('experts', 'clients', 'files'));

}



public function UpdateExpert(docRequest $request, $experts_id)
{

    $expert = expert::find($experts_id);
    if (!$expert)
        return redirect()->back();

    //update data



    $expert->update([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'date' => $request -> date,
        'time' => $request -> time,
        'missionAuthority' => $request -> missionAuthority,
        'expertName' => $request -> expertName,
        'value' => $request -> value,
        'type' => $request -> type,
        'subject' => $request -> subject,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

}








/*********************************************************** dispute ***********************************************************/






public function disputesPost(docRequest $request)
{


    dispute::create([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'TheSide' => $request -> TheSide,
        'rqNumber' => $request -> rqNumber,
        'rqdate' => $request -> rqdate,
        'WithdrawalDate' => $request -> WithdrawalDate,
        'time' => $request -> time,
        'recommendation' => $request -> recommendation,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successAdd' => '']);
}




public function AllDisputes() {



    $user = auth()->user();

    // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
    if ($user->hasRole('Admin')) {
        $disputes = dispute::orderBy('created_at', 'desc')->get();
    } else {
        // جلب القضايا المسموح للمستخدم برؤيتها
        $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
            return str_replace('ارقام القضايا', '', $permission);
        })->toArray();

        // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
        $disputes = dispute::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
    }


    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.disputes', compact('disputes', 'clients', 'files'));
}


public function deleteDispute($disputes_id)
{

    $disputes = dispute::find($disputes_id);

    if (!$disputes)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $disputes->delete();

    return redirect()->back()->with(['successDelete' => '']);
}





public function editDisputes($disputes_id)
{

    $disputes = dispute::find($disputes_id);  // search in given table id only
    if (!$disputes)
        return redirect()->back();
    $disputes = dispute::all()->find($disputes_id);
    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.editDispute', compact('disputes', 'clients', 'files'));

}



public function UpdateDisputes(docRequest $request, $disputes_id)
{

    $dispute = dispute::find($disputes_id);
    if (!$dispute)
        return redirect()->back();

    //update data



    $dispute->update([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'TheSide' => $request -> TheSide,
        'rqNumber' => $request -> rqNumber,
        'rqdate' => $request -> rqdate,
        'WithdrawalDate' => $request -> WithdrawalDate,
        'time' => $request -> time,
        'recommendation' => $request -> recommendation,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

}












/*********************************************************** family_dispute ***********************************************************/






public function family_disputePost(docRequest $request)
{


    family_dispute::create([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'office' => $request -> office,
        'rqNumber' => $request -> rqNumber,
        'rqdate' => $request -> rqdate,
        'Attend' => $request -> Attend,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successAdd' => '']);
}



public function AllFamily_disputes() {


    $user = auth()->user();

    // إذا كان المستخدم لديه دور Admin، اجلب جميع الجلسات
    if ($user->hasRole('Admin')) {
        $family_disputes = family_dispute::orderBy('created_at', 'desc')->get();
    } else {
        // جلب القضايا المسموح للمستخدم برؤيتها
        $allowedCaseIds = $user->permissions->pluck('name')->map(function ($permission) {
            return str_replace('ارقام القضايا', '', $permission);
        })->toArray();

        // جلب الجلسات التي تنتمي إلى القضايا المسموح بها
        $family_disputes = family_dispute::whereIn('file_id', $allowedCaseIds)->orderBy('created_at', 'desc')->get();
    }


    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.familyDisputes', compact('family_disputes', 'clients', 'files'));
}


public function deleteFamily_disputes($family_disputes_id)
{

    $family_disputes = family_dispute::find($family_disputes_id);

    if (!$family_disputes)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $family_disputes->delete();

    return redirect()->back()->with(['successDelete' => '']);
}





public function editFamily_disputes($family_disputes_id)
{

    $family_disputes = family_dispute::find($family_disputes_id);  // search in given table id only
    if (!$family_disputes)
        return redirect()->back();
    $family_disputes = family_dispute::all()->find($family_disputes_id);
    $clients =  client::All();
    $files =  file::All();
    return view('admin.dashboard.editFamilyDisputes', compact('family_disputes', 'clients', 'files'));

}



public function UpdateFamily_disputes(docRequest $request, $family_disputes_id)
{

    $family_dispute = family_dispute::find($family_disputes_id);
    if (!$family_dispute)
        return redirect()->back();

    //update data



    $family_dispute->update([
        'client_id' => $request -> client_id,
        'file_id' => $request -> file_id,
        'office' => $request -> office,
        'rqNumber' => $request -> rqNumber,
        'rqdate' => $request -> rqdate,
        'Attend' => $request -> Attend,
        'details' => $request -> details,
    ]);

    return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

}


}
