<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\courtsRequest;
use App\Http\Requests\documentation_officesRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\court;
use App\Models\file;
use App\Models\documentation_office;
use LaravelLocalization;
use App\Traits\allTraits;


class courtController extends Controller
{
    use allTraits;



    public function courtPost(courtsRequest $request)
    {


        court::create([
            'name' => $request -> name,
            'address' => $request -> address,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllCourts() {
        $courts =  court::All();
        return view('admin.dashboard.courts', compact('courts'));
    }


    public function deleteCourt($courts_id)
    {

        $courts = court::find($courts_id);

        if (!$courts)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $courts->delete();

        return redirect()
            ->route('AllCourts')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editCourt($courts_id)
    {

        $courts = court::find($courts_id);  // search in given table id only
        if (!$courts)
            return redirect()->back();
        $courts = court::all()->find($courts_id);
        return view('admin.dashboard.editCourt', compact('courts'));

    }



    public function UpdateCourt(courtsRequest $request, $courts_id)
    {

        $court = court::find($courts_id);
        if (!$court)
            return redirect()->back();

        //update data


        $court->update([
            'name' => $request -> name,
            'address' => $request -> address,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }













    /*********************** documentation_office *****************************/



    public function documentation_officesPost(documentation_officesRequest $request)
    {


        documentation_office::create([
            'name' => $request -> name,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllDocumentation_offices() {
        $documentation_offices =  documentation_office::All();
        return view('admin.dashboard.documentationOffice', compact('documentation_offices'));
    }


    public function deleteDocumentation_offices($documentation_offices_id)
    {

        $documentation_offices = documentation_office::find($documentation_offices_id);

        if (!$documentation_offices)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $documentation_offices->delete();

        return redirect()
            ->route('AllDocumentation_offices')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }




}
