<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use Illuminate\Http\Request;
use App\Http\Requests\blogRequest;
use App\Models\blog;
use App\Models\comment;
use Illuminate\Support\Facades\Auth;
use LaravelLocalization;
use App\Traits\allTraits;


class blogController extends Controller
{
    use allTraits;

    public function addBlog() {

        return view('admin.addBlog');
    }


    public function blogPost(blogRequest $request)
    {

        $file_name = $this->saveImage($request->photo, 'images/blogs');

        blog::create([
            'photo' => $file_name,
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'date' => $request -> date,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
            'user' => (Auth::user()->name),
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }



    public function allBlogs() {

        $blogs =  blog::All();
        return view('admin.blogs', compact('blogs'));
    }




    public function archiveBlogs($blogs_id)
    {

        $blogs = blog::find($blogs_id);

        if (!$blogs)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $blogs->delete();

        return redirect()
            ->route('allBlogs')
            ->with(['successMoved' => __('messages.news archive successfully')]);

    }


    public function editBlogs($blogs_id)
    {

        // addNews::findOrFail($news_id);
        $blogs = blog::find($blogs_id);  // search in given table id only
        if (!$blogs)
            return redirect()->back();

        $blogs = blog::all()->find($blogs_id);
        return view('admin.editBlog', compact('blogs'));


    }


    public function UpdateBlogs(blogRequest $request, $blogs_id)
    {
        //validtion
        $file_name = $this->saveImage($request->photo, 'images/blogs');
        // chek if offer exists

        $blog = blog::find($blogs_id);
        if (!$blog)
            return redirect()->back();

        //update data

        $blog->update([
            'photo' => $file_name,
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'date' => $request -> date,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
        ]);



        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }


    public function forceBlogDelete($blog_id)
    {

        blog::where('id', $blog_id)->withTrashed()->forceDelete();
        return redirect()->back()

        ->with(['successDelete' => __('messages.news deleted successfully')]);

    }


        /** blog Archived **/
        public function blogArchived()
        {
            $blogs = blog::onlyTrashed()->get();
            return view('admin.allBlogsArchive',compact('blogs'));
        }
        /**  /** blog Archived **/



    public function MarkAsRead_all (Request $request)
    {

        $userUnreadNotification= auth()->user()->unreadNotifications;

        if($userUnreadNotification) {
            $userUnreadNotification->markAsRead();
            return back();
        }

    }





    public function comments() {

        $comments = comment::with('blogs')->get();
        return view('admin.comments', compact('comments'));
    }




    public function deleteComment($comments_id)
    {

        $comments = comment::find($comments_id);

        if (!$comments)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $comments->delete();

        return redirect()
            ->route('comments')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }



}
