<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\attributesRequest;
use Illuminate\Support\Facades\Hash;
use App\Models\attribute;
use App\Models\file;
use LaravelLocalization;
use App\Traits\allTraits;


class attributesController extends Controller
{
    use allTraits;



    public function attributePost(attributesRequest $request)
    {


        attribute::create([
            'title' => $request -> title,
        ]);



        return redirect()->back()->with(['successAdd' => '']);
    }


    public function AllAttributes() {
        $attributes =  attribute::All();
        return view('admin.dashboard.attributes', compact('attributes'));
    }


    public function deleteAttribute($attributes_id)
    {

        $attributes = attribute::find($attributes_id);

        if (!$attributes)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $attributes->delete();

        return redirect()
            ->route('AllAttributes')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }







    public function editAttribute($attributes_id)
    {

        $attributes = attribute::find($attributes_id);  // search in given table id only
        if (!$attributes)
            return redirect()->back();
        $attributes = attribute::all()->find($attributes_id);
        return view('admin.dashboard.editAttributes', compact('attributes'));

    }



    public function UpdateAttribute(attributesRequest $request, $attributes_id)
    {

        $attribute = attribute::find($attributes_id);
        if (!$attribute)
            return redirect()->back();

        //update data


        $attribute->update([
            'title' => $request -> title,

        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }



}
