<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\userRequest;
use App\Models\admin;
use App\Models\logo;
use Illuminate\Support\Facades\Hash;



class adminController extends Controller
{


    public function users() {
        $admins =  admin::All();
        return view('admin.addUsers', compact('admins'));
    }






    public function userPost(userRequest $request)
    {


        admin::create([
            'email' => $request -> email,
            'password' => Hash::make($request->password),
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }




    public function allUsers() {

        $admins =  admin::All();
        $logos =  logo::All();
        return view('admin.allUsers', compact('admins', 'logos'));
    }



    public function deleteUser($admin_id)
    {

        $admins = admin::find($admin_id);

        if (!$admins)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $admins->delete();

        return redirect()
            ->route('allUsers')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }




}
