<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\aboutUsRequest;
use App\Http\Requests\accountingRequest;
use App\Http\Requests\expenseItemRequest;
use App\Models\client;
use App\Models\lawyersExpense;
use App\Models\clientIncome;
use App\Models\lawyer;
use App\Models\expense;
use App\Models\expenseItem;

use LaravelLocalization;
use App\Traits\allTraits;


class accountingController extends Controller
{
    use allTraits;

    public function addLawyersExpenses() {

        $lawyersExpenses =  lawyersExpense::All();
        return view('admin.dashboard.addLawyersExpenses', compact('lawyersExpenses'));
    }


    public function lawyersExpensesPost(accountingRequest $request)
    {

        lawyersExpense::create([
            'lawyer_id' => $request->lawyer_id,
            'date' => $request -> date,
            'money' => $request -> money,
            'details' => $request -> details,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }


    public function allLawyersExpense() {
        $lawyers =  lawyer::All();
        $lawyersExpenses =  lawyersExpense::All();
        return view('admin.dashboard.lawyersExpense', compact('lawyersExpenses', 'lawyers'));
    }


    public function deleteLawyersExpense($lawyersExpenses_id)
    {

        $lawyersExpenses = lawyersExpense::find($lawyersExpenses_id);

        if (!$lawyersExpenses)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $lawyersExpenses->delete();

        return redirect()
            ->route('allLawyersExpense')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }



    /******************Clientincome***************** */





    public function clientIncomePost(accountingRequest $request)
    {

        clientIncome::create([
            'client_id' => $request->client_id,
            'file_id' => $request->file_id,
            'date' => $request->date,
            'money' => $request->money,
            'details' => $request->details,
            'status' => $request->status,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }


    public function allClientIncome() {

        $clients = client::with('latestIncome')->get();

        return view('admin.dashboard.allClientIncome', compact('clients'));
    }


    public function deleteClientIncome($clientIncomes_id)
    {

        $clientIncomes = clientIncome::find($clientIncomes_id);

        if (!$clientIncomes)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $clientIncomes->delete();


            return redirect()->back()->with(['successDelete' => '']);

    }


    public function editClientIncome($clientIncomes_id)
    {

        // addNews::findOrFail($news_id);
        $clientIncomes = clientIncome::find($clientIncomes_id);  // search in given table id only
        if (!$clientIncomes)
            return redirect()->back();

        $clientIncomes = clientIncome::all()->find($clientIncomes_id);
        return view('admin.dashboard.editClientIncome', compact('clientIncomes'));


    }


    public function UpdateClientIncome(accountingRequest $request, $clientIncomes_id)
    {

        $clientIncome = clientIncome::find($clientIncomes_id);
        if (!$clientIncome)
            return redirect()->back();

        //update data

        $clientIncome->update([
            'client_id' => $request->client_id,
            'file_id' => $request->file_id,
            'date' => $request->date,
            'money' => $request->money,
            'details' => $request->details,
            'status' => $request->status,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }











    public function clientIncomeDetails($id)
    {
        $client = client::with('files.incomes')->findOrFail($id);

        return view('admin.dashboard.clientIncomeDetails', compact('client'));
    }




    public function updateStatus(Request $request)
    {
        $clientIncome = ClientIncome::where('client_id', $request->client_id)->latest('id')->first();

        if ($clientIncome) {
            $clientIncome->update(['status' => $request->status]);
        } else {
            ClientIncome::create([
                'client_id' => $request->client_id,
                'status' => $request->status,
                'file_id' => null,
                'date' => now(),
                'money' => 0,
                'details' => 'تحديث تلقائي'
            ]);
        }

        return response()->json(['success' => true]);
    }



    public function reportClientIncome()
    {
        $clients = client::all(); // جلب جميع الموكلين لعرضهم في القائمة المنسدلة
        return view('admin.reports.reportClientIncome', compact('clients'));
    }



    public function search(Request $request)
    {
        $clients = client::all(); // جلب جميع الموكلين لاستخدامهم في الفورم
        $client = null; // المتغير الذي سيتم إرساله للـ View

        $query = clientIncome::query();

        if ($request->has('client_id') && !empty($request->client_id)) {
            $client = client::find($request->client_id); // جلب بيانات الموكل المحدد
            $query->where('client_id', $request->client_id);
        }

        if ($request->has('month') && !empty($request->month)) {
            $query->whereMonth('date', date('m', strtotime($request->month)))
                  ->whereYear('date', date('Y', strtotime($request->month)));
        }

        $clientIncomes = $query->with('file')->get(); // جلب الدفعات وربطها بالقضايا
        $clientIncomes = $query->with('clients')->get(); // جلب الدفعات وربطها بالقضايا

        return view('admin.reports.reportClientIncome', compact('clients', 'clientIncomes', 'client'));
    }




    /*********************** expenses **********************/




    public function expenses() {

        $expenseItems = expenseItem::all();
        $expenses = expense::all();


        return view('admin.dashboard.expenses', compact('expenseItems', 'expenses'));
    }





    public function expenseItemPost(expenseItemRequest $request)
    {

        expenseItem::create([
            'title' => $request->title,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }



    public function deleteExpenseItem($expenseItems_id)
    {

        $expenseItems = expenseItem::find($expenseItems_id);

        if (!$expenseItems)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $expenseItems->delete();

            return redirect()->back()->with(['successDelete' => '']);

    }







    public function expensePost(accountingRequest $request)
    {
        expense::create([
            'expenseItem_id' => $request->expenseItem_id,
            'client_id' => $request->client_id,
            'money' => $request->money,
            'date' => $request->date,
            'details' => $request->details,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }




    public function deleteExpense($expenses_id)
    {

        $expenses = expense::find($expenses_id);

        if (!$expenses)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $expenses->delete();

            return redirect()->back()->with(['successDelete' => '']);

    }





}
