<?php
namespace App\Http\Controllers\admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;
class RoleController extends Controller
{
/**
* Display a listing of the resource.
*
* @return \Illuminate\Http\Response
*/
 function __construct()
 {
 $this->middleware('permission:المستخدمين', ['only' => ['index','store']]);
 $this->middleware('permission:المستخدمين', ['only' => ['create','store']]);
 $this->middleware('permission:المستخدمين', ['only' => ['show','store']]);
 $this->middleware('permission:المستخدمين', ['only' => ['edit','update']]);
 $this->middleware('permission:المستخدمين', ['only' => ['destroy']]);
}
/**
* Display a listing of the resource.
*
* @return \Illuminate\Http\Response
*/
public function index(Request $request)
{
$roles = Role::orderBy('id','DESC')->paginate(5);
return view('admin.roles.index',compact('roles'))
->with('i', ($request->input('page', 1) - 1) * 5);
}
/**
* Show the form for creating a new resource.
*
* @return \Illuminate\Http\Response
*/
public function create()
{
$permission = Permission::get();
return view('admin.roles.create',compact('permission'));

}
/**
* Store a newly created resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @return \Illuminate\Http\Response
*/
public function store(Request $request)
{
$this->validate($request, [
'name' => 'required|unique:roles,name',
'permission' => 'required',
]);
$role = Role::create(['name' => $request->input('name')]);
$role->syncPermissions($request->input('permission'));
return redirect()->back()->with(['successAdd' => '']);
}
/**
* Display the specified resource.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/
public function show($id)
{
$role = Role::find($id);
$rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
->where("role_has_permissions.role_id",$id)
->get();
return view('admin.roles.show',compact('role','rolePermissions'));
}
/**
* Show the form for editing the specified resource.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/
// public function rolesEdit($id)
// {
// $role = Role::find($id);
// $permission = Permission::get();
// $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$id)
// ->pluck('role_has_permissions.permission_id','role_has_permissions.permission_id')
// ->all();
// return view('roles.edit',compact('role','permission','rolePermissions'));
// }



public function rolesEdit($roles_id)
{
    // استرجاع الدور المحدد
    $role = Role::find($roles_id);

    if (!$role) {
        return redirect()->back()->with(['error' => 'الدور غير موجود']);
    }

    // استرجاع جميع الصلاحيات
    $permission = Permission::all();

    // استرجاع الصلاحيات المرتبطة بالدور
    $rolePermissions = DB::table("role_has_permissions")
        ->where("role_has_permissions.role_id", $roles_id)
        ->pluck('role_has_permissions.permission_id')
        ->toArray();

        $permissions = \Spatie\Permission\Models\Permission::whereNotIn('name', function ($query) {
            $query->select('name')
                  ->from('permissions')
                  ->where('name', 'LIKE', 'ارقام القضايا%')
                  ->orWhere('name', 'LIKE', 'view-case%');
        })->get();
    // عرض صفحة التعديل مع المتغيرات المطلوبة
    return view('admin.roles.edit', compact('role', 'permission', 'rolePermissions'));
}





/**
* Update the specified resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @param  int  $id
* @return \Illuminate\Http\Response
*/
public function updateRoles(Request $request, $id)
{
$this->validate($request, [
'name' => 'required',
'permission' => 'required',
]);
$role = Role::find($id);
$role->name = $request->input('name');
$role->save();
$role->syncPermissions($request->input('permission'));
return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);
}
/**
* Remove the specified resource from storage.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/
// public function destroy($id)
// {
// DB::table("roles")->where('id',$id)->delete();
// return redirect()->route('roles.index')
// ->with('success','Role deleted successfully');
// }



public function rolesDelete($role_id)
{

    $role = role::find($role_id);

    if (!$role)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $role->delete();

    return redirect()
        ->route('roles')
        ->with(['successDelete' => __('messages.news deleted successfully')]);

}
}






