<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\filesRequest;
use App\Models\client;
use App\Models\file;
use App\Models\session;
use App\Models\court;
use App\Models\attribute;
use App\Models\documentation_office;
use App\Models\attach;
use LaravelLocalization;
use App\Traits\allTraits;


class ReportsController extends Controller
{

    public function filePost(filesRequest $request)
    {

   $photo = array();
    if($files = $request->file('photo')){
        foreach($files as $file){
            $photo_name = md5(rand(1000, 10000));
            $ext = strtolower($file->getClientOriginalExtension()); // تعديل هنا
            $photo_full_name = $photo_name.'.'.$ext;
            $upload_path = 'images/casefiles/';
            $photo_url = $upload_path.$photo_full_name;
            $file->move($upload_path, $photo_full_name);
            $photo[] = $photo_url;
        }
    }
        file::create([
            'client_id' => $request -> client_id,
            'attribute_id' => $request -> attribute_id,
            'court_id' => $request -> court_id,
            'documentation_office_id' => $request -> documentation_office_id,
            'caseNum' => $request -> caseNum,
            'litigationDegree' => $request -> litigationDegree,
            'photo' => implode('|', $photo),
            'opponentName' => $request -> opponentName,
            'attorneyType' => $request -> attorneyType,
            'opponentAddress' => $request -> opponentAddress,
            'professorsLawyer' => $request -> professorsLawyer,
            'caseType' => $request -> caseType,
            'details' => $request -> details,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }


    public function addFiles() {

        $clients =  client::All();
        $attributes =  attribute::All();
        $courts =  court::All();
        $documentation_offices =  documentation_office::All();
        return view('admin.dashboard.addFiles', compact('clients', 'attributes', 'courts', 'documentation_offices'));
    }


    public function AllFiles() {
        $files =  file::All();
        $clients =  client::All();
        $attributes =  attribute::All();
        $courts =  court::All();
        $documentation_offices =  documentation_office::All();
        return view('admin.dashboard.files', compact('clients', 'files', 'attributes', 'courts', 'documentation_offices'));
    }


    public function archiveFiles($files_id)
    {

        $files = file::find($files_id);

        if (!$files)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $files->delete();

        return redirect()
            ->route('AllFiles')
            ->with(['successArchive' => __('messages.news deleted successfully')]);
    }


    public function filesTrashed()
    {
        $files = file::onlyTrashed()->get();
        return view('admin.dashboard.filesArchive',compact('files'));
    }





    public function Deletefile($files_id)
    {

        file::where('id', $files_id)->withTrashed()->forceDelete();
        return redirect()->back()

        ->with(['successDelete' => __('messages.news deleted successfully')]);

    }





    public function editFiles($files_id)
    {

        $files = file::find($files_id);  // search in given table id only
        if (!$files)
            return redirect()->back();
        $files = file::all()->find($files_id);
        return view('admin.dashboard.editFile', compact('files'));

    }



    public function UpdateFiles(filesRequest $request, $files_id)
    {

        $file = file::find($files_id);
        if (!$file)
            return redirect()->back();

        //update data



        $file->update([
            'client_id' => $request -> client_id,
            'attribute_id' => $request -> attribute_id,
            'court_id' => $request -> court_id,
            'documentation_office_id' => $request -> documentation_office_id,
            'caseNum' => $request -> caseNum,
            'litigationDegree' => $request -> litigationDegree,
            'opponentName' => $request -> opponentName,
            'attorneyType' => $request -> attorneyType,
            'opponentAddress' => $request -> opponentAddress,
            'professorsLawyer' => $request -> professorsLawyer,
            'caseType' => $request -> caseType,
            'details' => $request -> details,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }





    public function fileDetails($files_id)
    {
        $files = file::find($files_id);
        if (!$files)
            return redirect()->back();

        $files = file::all()->find($files_id);
        $sessions  = session ::where('file_id',$files_id)->get();
        $attaches  = attach ::where('file_id',$files_id)->get();

        return view('admin.dashboard.fileDetails', compact('sessions', 'files', 'attaches'));
    }





}
