<?php


namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use LaravelLocalization;
use App\Http\Requests\LoginRequest;
use App\Models\Admin;
use App\Models\logo;
use App\Models\file;
use Auth;

class loginController extends Controller
{


    public function  getLogin(){

        $logos =  logo::All();
        return view('admin.auth.login', compact('logos'));
    }


    public function save(){

        $admin = new App\Models\Admin();
        $admin -> email ="admin@gmail.com";
        $admin -> password = bcrypt("admin@admin");
        $admin -> save();

    }

    public function login(LoginRequest $request)
    {
        $remember_me = $request->has('remember_me');

        if (auth()->guard('admin')->attempt(['email' => $request->email, 'password' => $request->password], $remember_me)) {
            $user = auth()->guard('admin')->user();

            // جلب جميع القضايا الخاصة بالمستخدم وإعطاؤه الصلاحيات المتعلقة بها
            $files = File::where('admin_id', $user->id)->get(); // تعديل حسب علاقة القضايا بالمستخدم

            foreach ($files as $file) {
                $permissionName = 'view-case-' . $file->id;

                // التحقق مما إذا كانت الصلاحية موجودة بالفعل، وإن لم تكن، يتم إنشاؤها
                Permission::firstOrCreate(['name' => $permissionName]);

                // منح المستخدم الصلاحية الخاصة بالقضية
                if (!$user->hasPermissionTo($permissionName)) {
                    $user->givePermissionTo($permissionName);
                }
            }

            return redirect()->route('admin.dashboard')->with('success', 'تم تسجيل الدخول بنجاح');
        }

        return redirect()->back()->with(['error' => 'خطأ في بيانات تسجيل الدخول']);
    }



   public function logout()
   {
       if(Auth::guard('admin')->check()) // this means that the admin was logged in.
       {
           Auth::guard('admin')->logout();
           return redirect()->route('login');
       }

   }

}
