<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\casesRequest;
use App\Models\caseModel;
use LaravelLocalization;
use App\Traits\allTraits;


class CasesController extends Controller
{
    use allTraits;



    public function casePost(casesRequest $request)
    {

        $file_name = $this->saveImage($request->photo, 'images/cases');

        caseModel::create([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'photo' => $file_name,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }


    public function cases() {
        $cases_s =  caseModel::All();
        return view('admin.dashboard.cases', compact('cases_s'));
    }


    public function deleteCases($cases_s_id)
    {

        $cases_s = caseModel::find($cases_s_id);

        if (!$cases_s)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $cases_s->delete();

        return redirect()
            ->route('cases')
            ->with(['successDelete' => __('messages.news deleted successfully')]);
    }


    public function editCases($cases_s_id)
    {


        $cases_s = caseModel::find($cases_s_id);  // search in given table id only
        if (!$cases_s)
            return redirect()->back();

        $cases_s = caseModel::all()->find($cases_s_id);
        return view('admin.dashboard.editCases', compact('cases_s'));

    }


    public function UpdateCases(Request $request, $cases_s_id)
    {

        $caseModel = caseModel::find($cases_s_id);
        if (!$caseModel)
            return redirect()->back();
            

      // معالجة الصورة الأساسية (photo)
    if ($request->hasFile('photo')) {
        $file_name = $this->saveImage($request->photo, 'images/cases');
    } else {
        $file_name = $caseModel->photo; // الاحتفاظ بالصورة الحالية
    }
        //update data

        $caseModel->update([
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'photo' => $file_name,
            'details_ar' => $request -> details_ar,
            'details_en' => $request -> details_en,
        ]);

        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);

    }








}
