<?php
namespace App\Http\Controllers\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
class UserController extends Controller
{
/**
* Display a listing of the resource.
*
* @return \Illuminate\Http\Response
*/

function __construct()
{
$this->middleware('permission:المستخدمين', ['only' => ['index','store']]);
$this->middleware('permission:المستخدمين', ['only' => ['create','store']]);
$this->middleware('permission:المستخدمين', ['only' => ['editUser','update']]);
$this->middleware('permission:المستخدمين', ['only' => ['delete']]);
}
public function index(Request $request)
{
$data = User::orderBy('id','DESC')->paginate(5);
$roles = Role::pluck('name','name')->all();
$roles = role::get();
return view('admin.users.index',compact('data', 'roles'))
->with('i', ($request->input('page', 1) - 1) * 5);
}
/**
* Show the form for creating a new resource.
*
* @return \Illuminate\Http\Response
*/
public function create()
{
$roles = Role::pluck('name','name')->all();
return view('admin.users.create',compact('roles'));
}
/**
* Store a newly created resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @return \Illuminate\Http\Response
*/
public function store(Request $request)
{
$this->validate($request, [
'name' => 'required',
'email' => 'required|email|unique:users,email',
'password' => 'required|same:confirm-password',
'getRoleNames' => 'required'
]);
$input = $request->all();
$input['password'] = Hash::make($input['password']);
$user = User::create($input);
$user->assignRole($request->input('getRoleNames'));
return redirect()->route('users')
->with('success','User created successfully');
}
/**
* Display the specified resource.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/
public function show($id)
{
$user = User::find($id);
return view('admin.users.show',compact('user'));
}
/**
* Show the form for editing the specified resource.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/


public function editUser($users_id)
{

    // addNews::findOrFail($news_id);
    $user = user::find($users_id);  // search in given table id only
    if (!$user)
        return redirect()->back();
    $users = $user::all()->find($users_id);
    $roles = Role::pluck('name','name')->all();
    $userRole = $user->roles->pluck('name','name')->all();
    $roles = role::get();

    return view('admin.users.edit', compact('user','roles','userRole'));

}





/**
* Update the specified resource in storage.
*
* @param  \Illuminate\Http\Request  $request
* @param  int  $id
* @return \Illuminate\Http\Response
*/
public function updateUser(Request $request, $id)
{
$this->validate($request, [
'name' => 'required',
'email' => 'required|email|unique:users,email,'.$id,
'getRoleNames' => 'required'
]);
$input = $request->all();
$user = User::find($id);
$user->update($input);
DB::table('model_has_roles')->where('model_id',$id)->delete();
$user->assignRole($request->input('getRoleNames'));
return redirect()->route('users')
->with('success','User updated successfully');
}
/**
* Remove the specified resource from storage.
*
* @param  int  $id
* @return \Illuminate\Http\Response
*/


// public function destroy($id)
// {
// User::find($id)->delete();
// return redirect()->route('users')
// ->with('success','User deleted successfully');

// }

public function deleteUser($user_id)
{

    $user = user::find($user_id);

    if (!$user)
        return redirect()->back()->with(['error' => __('messages.news not exist')]);

    $user->delete();

    return redirect()
        ->route('admin.users.index')
        ->with(['successDelete' => __('messages.news deleted successfully')]);

}

}


